<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRoleAccessTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('roles_access', function (Blueprint $table) {
            $table->bigincrements('roleaccess_id');
            $table->bigInteger('role_id')->unsigned();
            $table->string('roleaccess_formcode', 60);
            $table->boolean('roleaccess_insert')->default(false);
            $table->boolean('roleaccess_update')->default(false);
            $table->boolean('roleaccess_delete')->default(false);
            $table->boolean('roleaccess_view')->default(false);
            $table->foreign('role_id')->references('role_id')->on('roles')->onDelete('RESTRICT');
        });

        DB::table('roles_access')->insert(

            [
                ['role_id' => "1",
                    'roleaccess_formcode' => "items-groups",
                    'roleaccess_insert' => "1",
                    'roleaccess_update' => "1",
                    'roleaccess_delete' => "1",
                    'roleaccess_view' => "1",], [
                'role_id' => "1",
                'roleaccess_formcode' => "items",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "dashboard-section4",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "dashboard-section3",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "dashboard-section2",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "dashboard-section1",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "users",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "user-access-rights",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "roles",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "setups",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "locations",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "countries",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "inventory-report",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "reports",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "delivery",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "RMAIN",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "goodsIn",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "clients",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "suppliers",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "forwarders",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "shipments",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "customers",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "Delivery-report",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ], [
                'role_id' => "1",
                'roleaccess_formcode' => "GoodsIn-report",
                'roleaccess_insert' => "1",
                'roleaccess_update' => "1",
                'roleaccess_delete' => "1",
                'roleaccess_view' => "1",
            ],

            ]
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('role_access');
    }
}
