<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionPaletsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transaction_palets', function (Blueprint $table) {
            $table->bigincrements('palet_id');
            $table->string('palet_no');
            $table->unsignedBigInteger('transaction_id');
            $table->string('palet_dimension');
            $table->string('palet_weight');
            $table->foreign('transaction_id')->references('transaction_id')->on('transactions')->onDelete('CASCADE');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transaction_palets');
    }
}
