<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ClientCustomers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('client_customers', function (Blueprint $table) {
            $table->bigIncrements('customer_id')->unsigned();
            $table->string('customer_name', 50);
            $table->string('customer_contactPerson')->nullable();
            $table->string('customer_address',)->nullable();
            $table->integer('customer_country');
            $table->string('customer_phone', 100)->nullable();
            $table->string('customer_email', 100)->nullable();
            $table->string('customer_phone_code', 100)->nullable();
            $table->integer('customer_related_clientid');
            $table->boolean('isActive')->default(true);


        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_customers');

    }
}
