<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class GroupsHistory extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('mysql2')->create('item_groups', function (Blueprint $table) {
            $table->bigincrements('index');
            $table->bigInteger('group_id');
            $table->string('group_code');
            $table->string('group_name');
            $table->string('company_id');
            $table->string('group_itempack');
            $table->string('group_itemunit');
            $table->boolean('isActive')->default(true);
            $table->bigInteger('user_modified');
            $table->dateTime('date_modified');
            $table->string('modification_type');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
