<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class SuppliersHistory extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('mysql2')->create('suppliers', function (Blueprint $table) {
            $table->bigincrements('index');
            $table->bigInteger('supplier_id');
            $table->string('supplier_name');
            $table->string('supplier_contactPerson')->nullable();
            $table->string('supplier_address')->nullable();
            $table->bigInteger('supplier_country')->nullable();
            $table->string('supplier_phone')->nullable();
            $table->string('supplier_email')->nullable();
            $table->boolean('isActive')->default(true);
            $table->bigInteger('company_id')->nullable();
            $table->bigInteger('user_modified');
            $table->dateTime('date_modified');
            $table->string('modification_type');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
