<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ClientForwarders extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('mysql2')->create('client_forwarders', function (Blueprint $table) {
            $table->bigincrements('index');
            $table->bigInteger('clientforwarder_id');
            $table->string('clientforwarder_name', 32);
            $table->string('clientforwarder_contactPerson', 32);
            $table->string('clientforwarder_phone', 16);
            $table->string('clientforwarder_email', 32)->nullable();
            $table->string('clientforwarder_address', 100)->nullable();
            $table->string('clientforwarder_tradeLicenseNumber', 64);
            $table->string('clientforwarder_mercalTo', 64)->nullable();
            $table->string('clientforwarder_importCode', 64)->nullable();
            $table->bigInteger('user_modified');
            $table->dateTime('date_modified');
            $table->string('modification_type');
            $table->bigInteger('company_id')->nullable();
            $table->boolean('isActive')->default(true);
            $table->boolean('clientforwarder_approved')->default(true);

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
