<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ClientStorageRent extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('client_storage_rent', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('date_from');
            $table->bigInteger('date_to');
            $table->string('storage_type');
            $table->double('cost')->nullable()->default(0);
            $table->integer('unit_cost')->nullable();
            $table->integer('related_client_id');
            $table->boolean('active')->nullable()->default(false);

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('client_storage_rent', function (Blueprint $table) {
            //
        });
    }
}
