<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDeliveryStatus extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('delivery_status', function (Blueprint $table) {
            $table->bigIncrements('delivery_status_id');
            $table->bigInteger('transaction_id')->unsigned();
            $table->string('delivery_status')->nullable();
            $table->bigInteger('delivery_created_at')->nullable();
            $table->foreign('transaction_id')->references('transaction_id')->on('transactions')->onDelete('CASCADE');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transaction_status', function (Blueprint $table) {
            //
        });
    }
}
