<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class Paymenttable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('paymentMethods', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('code');
            $table->string('ledger_number');
        });

        $records = DB::table('set_ups')
        ->where('setup_type','payment_method')
        ->get();

        foreach ($records as $record) {
            DB::table('paymentMethods')->insert([
                'id' => $record->setup_id,
                'name' => $record->setup_value,
                'code' => $record->setup_key,
                'ledger_number' => 0
            ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('paymentMethods');
    }
}
