<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddItemsCBM extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('items', function (Blueprint $table) {
            $table->double('item_width')->nullable()->default(0);
            $table->double('item_length')->nullable()->default(0);
            $table->double('item_height')->nullable()->default(0);
            $table->double('item_cbm')->nullable()->default(0);
        });
        Schema::table('client_items', function (Blueprint $table) {
            $table->double('item_width')->nullable()->default(0);
            $table->double('item_length')->nullable()->default(0);
            $table->double('item_height')->nullable()->default(0);
            $table->double('item_cbm')->nullable()->default(0);
        });
        Schema::connection('mysql2')->table('items', function (Blueprint $table) {
            $table->double('item_width')->nullable()->default(0);
            $table->double('item_length')->nullable()->default(0);
            $table->double('item_height')->nullable()->default(0);
            $table->double('item_cbm')->nullable()->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('clients', function (Blueprint $table) {
            //
        });
    }
}
