<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class fixTransactionRemarkValue extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        DB::table('transactions')
            ->whereNull('transaction_remark')
            ->update(['transaction_remark' => '']);

        DB::table('transactiontmps')
            ->whereNull('transactiontmp_remark')
            ->update(['transactiontmp_remark' => '']);

        Schema::table('transactions', function (Blueprint $table) {
            $table->string('transaction_remark')->default('')->change();
        });

        Schema::table('transactiontmps', function (Blueprint $table) {
            $table->string('transactiontmp_remark')->default('')->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->string('transaction_remark')->nullable()->default(null)->change();
        });

        Schema::table('transactiontmps', function (Blueprint $table) {
            $table->string('transactiontmp_remark')->nullable()->default(null)->change();
        });
    }
}
