<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AddVersionField extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->integer('version')->default(1); // Default version starts at 1
        });

        DB::unprepared('
        CREATE TRIGGER increment_version_before_update
        BEFORE UPDATE ON transactions
        FOR EACH ROW
        BEGIN
            SET NEW.version = OLD.version + 1;
        END
    ');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::unprepared('DROP TRIGGER IF EXISTS increment_version_before_update');

        // Remove the 'version' column
        Schema::table('transactions', function (Blueprint $table) {
            $table->dropColumn('version');
        });
    }
}
