<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Schema;

class FillDOBOE extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::beginTransaction();

        try {
            // Update the transaction_dts table to ensure consistency with the subquery
            DB::table('transaction_dts as gd')
                ->join('transaction_dts as do', 'do.id_reference_dt', 'gd.transactiondt_id')
                ->update([
                    'do.transactiondt_BOE' => DB::raw('gd.transactiondt_BOE')
                ]);

                DB::table('transaction_dts as gd')
                ->join('transaction_dts as do', 'do.transactiondt_id', 'gd.reference_internal_dt')
                ->update([
                    'gd.transactiondt_BOE' => DB::raw('do.transactiondt_BOE')
                ]);
            // Commit the transaction if everything runs smoothly
            DB::commit();
        } catch (\Exception $e) {
            // Rollback if an error occurs
            DB::rollBack();

            // Optionally, you can log the error or handle it as needed
            throw $e;
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
