<html>
<head>
    <meta charset="utf-8">
    <title>تقرير النقل الداخلي</title>
</head>
<body>
    <div class="frame">
        <header>
        @section('content')
            <div>
                @include('./components/logo' ,['company' => $company] )
            </div>
            @endsection
            <x-logo :company="$company"></x-logo>
            <h1><u>النقل الداخلي</u></h1>
        </header>
        <br>
        <table class="inventory">
            <tr>
                <td class="nullclass" width="70%"></td>
                <th width="10%"> <span >المرجع</span></th>
                <td width="15%"> <span>{{$transaction->transaction_reference}}</span></td>
            </tr>
            <tr>
                <td class="nullclass" width="70%"></td>
                <th><span >من</span></th>
                <td><span>{{$transaction->client_firstname}}</span></td>
            </tr>
            <tr>
                <td class="nullclass" width="70%"></td>
                <th><span >إلى</span></th>
                <td><span>{{$transaction->toclient}}</span></td>
            </tr>
        </table>
        <br>
        <table class="inventory">
            <thead>
                <tr>
                    <td colspan="4"><span></span>
                    <th colspan="2"><span></span>وحدة</th>
                    <th colspan="3"><span>الإجمالي</span></th>
                </tr>
                <tr>
                    <th><span>العنصر</span></th>
                    <th><span>الوصف</span></th>
                    <th><span>الموقع</span></th>
                    <th><span>بلد المنشأ</span></th>
                    <th><span>الوزن</span></th>
                    <th><span>السعر</span></th>
                    <th><span>الكمية</span></th>
                    <th><span>الوزن</span></th>
                    <th><span>السعر ({{$transaction->currency_code}})</span></th>
                </tr>
            </thead>
            <?php $qty=0?>
            @for($j =0; $j < count($transactiondt); $j++ )
            <tbody>
            <tr>
                <td><span>{{$transactiondt[$j]->item_code}}</span></td>
                <td><span>{{$transactiondt[$j]->transactiondt_item_description}}</span></td>
                <td><span>{{$transactiondt[$j]->location_name}}</span></td>
                <td><span>{{$transactiondt[$j]->country_name}}</span></td>
                <td style="text-align: right;"><span>{{$transactiondt[$j]->item_weight}}</span></td>
                <td style="text-align: right;"><span>{{$transactiondt[$j]->transactiondt_price}}</span></td>
                <td style="text-align: right;"><span>{{$transactiondt[$j]->item_quantity}}</span></td>
                <td style="text-align: right;"><span>{{$transactiondt[$j]->total_weight}}</span></td>
                <td style="text-align: right;"><span>{{$transactiondt[$j]->total_price}}</span></td>
            </tr>
            @endFor
            <tr>
                <th colspan="6"><span>الإجمالي الكلي</span></th>
                <td style="background-color:#D6EAF8 ; text-align: right;"> {{$total->total_qty}}</td>
                <td style="background-color:#D6EAF8 ; text-align: right;"> {{$total->total_weight}}</td>
                <td style="background-color:#D6EAF8 ; text-align: right;">{{$total->total_price}} </td>
            </tr>
        </tbody>
        </table>
    </div>
    <div>
        @include('./components/footer',['company' => $company] )
    </div>
</body>
</html>

<style type="text/css">
    /* reset */


    .frame
	{
        padding-left: 2%;
		width: 96%;
		max-width: 680px;
		margin: 0 ;
	}


*
    {
        border: 0;
        box-sizing: content-box;
        color: inherit;
        font-family: inherit;
        font-size: inherit;
        font-style: inherit;
        font-weight: inherit;
        line-height: inherit;
        list-style: none;

    }

    /* content editable */

    *[contenteditable] { border-radius: 0.25em; min-width: 1em; outline: 0; }

    *[contenteditable] { cursor: pointer; }

    *[contenteditable]:hover, *[contenteditable]:focus, td:hover *[contenteditable], td:focus *[contenteditable], img.hover { background: #DEF; box-shadow: 0 0 1em 0.5em #DEF; }

    span[contenteditable] { display: inline-block; position: absolute }

    /* heading */

    h1 { font: bold 100% sans-serif; text-align: center; text-transform: uppercase; }

    hr {
    border: 0;
    clear:both;
    display:block;
    width: 96%;               
    background-color:black;
    height: 1px;
    vertical-align:center;
    }

    /* table */

    table { font-size: 75%; table-layout: fixed; width: 100%; }
    table { border-collapse: separate; border-spacing: 2px; }
    th, td { padding: 0.3em; position: relative; text-align: left;  position: absolute}
    th, td { border-radius: 0.25em; border-style: solid;  position: absolute}
    th { background: #E6E6E6; border-color: #BBB;  position: absolute}
    td { border-color: rgb(170 166 166 / 33%);  position: absolute}
    td.nullclass {border-color:#0000}





    /* invoice title */

    .txt { font-size: 75%; table-layout: fixed; width: 95%; position: absolute}










    /* table meta & balance */

    table.meta, table.balance { float: right; width: 50%; text-align: center;position: absolute }
    table.meta:after, table.balance:after { clear: both; content: ""; display: table; text-align: center;position: absolute }

    /* table meta */

    table.meta th { width: 40%;text-align: center;position: absolute }
    table.meta td { width: 60%;text-align: center; position: absolute }

    /* table items */

    table.inventory { clear: both; width: 100%;position: absolute font-size:15px;}
    table.inventory th { font-weight: bold; text-align: center; position: absolutefont-size:15px;}

    table.inventory td { text-align: center; position: absolutefont-size:10px; }
    table.inventory td.bigFontTd { text-align: center; position: absolutefont-size:13px;font-weight: bold;}
    table.inventory td.small { text-align: center; position: absolutefont-size:8px; }
    /* table balance */

    table.balance th, table.balance td { width: 50%; text-align: center;position: absolute }
    table.balance td { text-align: center;position: absolute}

    /* aside */


    @page {
        margin-bottom: 50;

        header: page-header;
        footer: page-footer;
    }
    </style>
