<html dir="{{$moduleKeys['direction'][$language]}}">

<head>
    <meta charset="utf-8">
    <title>{{$moduleKeys['clientMovement'][$language]}}</title>


</head>

<body dir="{{$moduleKeys['direction'][$language]}}">
    <div class="frame">
        <header>
            <br>

            @section('content')
            <div>
                @include('./components/logo' ,['company' => $company] )
            </div>
            @endsection
            <x-logo :company="$company"></x-logo>



            <h1><u>{{$moduleKeys['clientMovement'][$language]}}</u></h1>

        </header>

        <body dir="{{$moduleKeys['direction'][$language]}}">
            <table class="inventory">
                <tr>
                    <th width="10%"><span>{{$moduleKeys['client'][$language]}}</span></th>
                    <td width="40%"><span>{{$client}}</span></td>
                    <th width="10%"><span>{{$moduleKeys['from'][$language]}}</span></th>
                    <td width="20%"><span>{{$transactionSearchRequest->fromDate}}</span></td>

                </tr>
                <tr>
                <tr>
                    <th width="10%"><span>{{$moduleKeys['type'][$language]}}</span></th>
                    <td width="40%"> <span>{{ is_array($transactionSearchRequest->type) ? implode(', ', $transactionSearchRequest->type) : $transactionSearchRequest->type }}</span>
                    </td>
                </tr>
                <th width="10%"><span>{{$moduleKeys['to'][$language]}}</span></th>
                <td width="20%"><span>{{$transactionSearchRequest->toDate}}</span></td>

                </tr>




            </table>

            <table class="inventory">
                <thead>

                    <tr>
                        <th colspan="2"><span></span>{{$moduleKeys['type'][$language]}}</th>
                        <th colspan="2"><span></span>{{$moduleKeys['reference'][$language]}}</th>
                        <th colspan="2"><span></span>{{$moduleKeys['date'][$language]}}</th>
                        <th colspan="2"><span></span>{{$moduleKeys['client'][$language]}}</th>
                        <th colspan="2"><span></span>{{$moduleKeys['dec'][$language]}}</th>
                        @if($transactionSearchRequest->hasFiles)
                        <th colspan="1"><span></span>{{$moduleKeys['hasFiles'][$language]}}</th>


                        @endif

                    </tr>

                </thead>

                @for($j =0; $j < count($result->data); $j++ )
                    <tr>
                        <td colspan="2"><span>{{$result->data[$j]->transaction_type}}</span></td>
                        <td colspan="2"><span>{{$result->data[$j]->transaction_reference}}</span></td>
                        <td colspan="2"><span>{{$result->data[$j]->transaction_formatdate}}</span></td>
                        <td colspan="2"><span>{{$result->data[$j]->client_firstname}}</span></td>
                        <td colspan="2"><span>{{$result->data[$j]->transaction_billOfEntry}}</span></td>

                        @if($transactionSearchRequest->hasFiles)
                        @if($result->data[$j]->haveFiles)
                        <td colspan="1"><span>True</span></td>
                        @else
                        <td colspan="1"><span>False</span></td>

                        @endif

                        @endif



                    </tr>

                    @endfor
                    </tbody>

            </table>

        </body>

















        <div>
            @include('./components/footer',['company' => $company] )
        </div>

</body>

</html>
<style type="text/css">
    /* reset */

    .frame {
        padding-left: 2%;
        width: 96%;
        max-width: 680px;
        margin: 0;
    }

    * {
        border: 0;
        box-sizing: content-box;
        color: inherit;
        font-family: inherit;
        font-size: inherit;
        font-style: inherit;
        font-weight: inherit;
        line-height: inherit;
        list-style: none;
        margin: 0;
        padding: 0;
        text-decoration: none;
        vertical-align: top;
    }

    /* content editable */

    *[contenteditable] {
        border-radius: 0.25em;
        min-width: 1em;
        outline: 0;
    }

    *[contenteditable] {
        cursor: pointer;
    }

    *[contenteditable]:hover,
    *[contenteditable]:focus,
    td:hover *[contenteditable],
    td:focus *[contenteditable],
    img.hover {
        background: #DEF;
        box-shadow: 0 0 1em 0.5em #DEF;
    }

    span[contenteditable] {
        display: inline-block;
        position: absolute
    }

    /* heading */

    h1 {
        font: bold 100% sans-serif;
        text-align: center;
        text-transform: uppercase;
    }

    hr {
        border: 0;
        clear: both;
        display: block;
        width: 96%;
        background-color: black;
        height: 1px;
        vertical-align: center;
    }

    /* table */

    table {
        font-size: 75%;
        table-layout: fixed;
        width: 100%;
    }

    table {
        border-collapse: separate;
        border-spacing: 2px;
    }

    th,
    td {
        padding: 0.5em;
        position: relative;
        text-align: left;
        position: absolute
    }

    th,
    td {
        border-radius: 0.25em;
        border-style: solid;
        position: absolute
    }

    th {
        background: #E6E6E6;
        border-color: #BBB;
        position: absolute
    }

    td {
        border-color: rgb(170 166 166 / 33%);
        position: absolute
    }

    td.nullclass {
        border-color: #0000
    }

    /* page */

    html {
        font: 16px/1 'Open Sans', sans-serif;
        overflow: auto;
        padding: 0.5in;
    }

    html {
        background: #999;
        cursor: default;
    }

    body {
        box-sizing: border-box;
        height: 11in;
        margin: 0 auto;
        overflow: hidden;
        padding: 0.5in;
        width: 8.5in;
    }

    body {
        background: #FFF;
        border-radius: 1px;
        box-shadow: 0 0 1in -0.25in rgba(0, 0, 0, 0.5);
    }

    /* header */

    header {
        margin: 0 0 0.25em;
    }

    header:after {
        clear: both;
        content: "";
        display: table;
    }

    header h1 {
        padding: 0.5em 0;
    }

    header address {
        float: left;
        font-size: 75%;
        font-style: normal;
        line-height: 1.25;
        margin: 0 1em 1em 0;
    }

    header address p {
        margin: 0 0 0.25em;
    }

    header span,
    header img {
        display: block;
        float: right;
    }

    header span {
        margin: 0 0 1em 1em;
        max-height: 25%;
        max-width: 60%;
        position: relative;
    }

    header img {
        max-height: 100%;
        max-width: 100%;
    }

    header input {
        cursor: pointer;
        -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";
        height: 100%;
        left: 0;
        opacity: 0;
        position: absolute;
        top: 0;
        width: 100%;
    }

    /* article */



    /* invoice title */

    .txt {
        font-size: 75%;
        table-layout: fixed;
        width: 95%;
        position: absolute
    }

    invoiceTitle {
        float: left;
        font-size: 125%;
        font-weight: bold;
        text-align: center;
    }


    /* end invoice title */






    article,
    article address,
    table.meta,
    table.inventory {
        margin: 0 0 3em;
        position: absolute
    }

    article:after {
        clear: both;
        content: "";
        display: table;
    }

    article h1 {
        clip: rect(0 0 0 0);
        position: absolute;
    }

    article address {
        float: left;
        font-size: 125%;
        font-weight: bold;
    }

    /* table meta & balance */

    table.meta,
    table.balance {
        float: right;
        width: 50%;
        text-align: center;
        position: absolute
    }

    table.meta:after,
    table.balance:after {
        clear: both;
        content: "";
        display: table;
        text-align: center;
        position: absolute
    }

    /* table meta */

    table.meta th {
        width: 40%;
        text-align: center;
        position: absolute
    }

    table.meta td {
        width: 60%;
        text-align: center;
        position: absolute
    }

    /* table items */

    table.inventory {
        clear: both;
        width: 100%;
        position: absolute font-size:15px;
    }

    table.inventory th {
        font-weight: bold;
        text-align: center;
        position: absolutefont-size:15px;
    }

    table.inventory td {
        text-align: center;
        position: absolutefont-size:10px;
    }

    table.inventory td.bigFontTd {
        text-align: center;
        position: absolutefont-size:13px;
        font-weight: bold;
    }

    table.inventory td.small {
        text-align: center;
        position: absolutefont-size:8px;
    }

    /* table balance */

    table.balance th,
    table.balance td {
        width: 50%;
        text-align: center;
        position: absolute
    }

    table.balance td {
        text-align: center;
        position: absolute
    }

    /* aside */

    aside h1 {
        border: none;
        border-width: 0 0 1px;
        margin: 0 0 1em;
    }

    aside h1 {
        border-color: #999;
        border-bottom-style: solid;
    }

    /* javascript */

    .add,
    .cut {
        border-width: 1px;
        display: block;
        font-size: .8rem;
        padding: 0.25em 0.5em;
        float: left;
        text-align: center;
        width: 0.6em;
    }

    .fontCustomer {
        font-size: 1.875em;
        /* 30px/16=1.875em */
    }

    .add,
    .cut {
        background: #9AF;
        box-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);
        background-image: -moz-linear-gradient(#00ADEE 5%, #0078A5 100%);
        background-image: -webkit-linear-gradient(#00ADEE 5%, #0078A5 100%);
        border-radius: 0.5em;
        border-color: #0076A3;
        color: #FFF;
        cursor: pointer;
        font-weight: bold;
        text-shadow: 0 -1px 2px rgba(0, 0, 0, 0.333);
    }

    .logo {
        border: none;
        border-width: 0 0 1px;
        margin: 0 0 2em;
    }

    .add {
        margin: -2.5em 0 0;
    }

    .add:hover {
        background: #00ADEE;
    }

    .cut {
        opacity: 0;
        position: absolute;
        top: 0;
        left: -1.5em;
    }

    .cut {
        -webkit-transition: opacity 100ms ease-in;
    }

    tr:hover .cut {
        opacity: 1;
    }

    @media print {
        * {
            -webkit-print-color-adjust: exact;
        }

        html {
            background: none;
            padding: 0;
        }

        body {
            box-shadow: none;
            margin: 0;
        }

        span:empty {
            display: none;
        }

        .add,
        .cut {
            display: none;
        }
    }

    @page {
        margin: 0;
    }

    @page {
        margin-bottom: 50;


        header: page-header;
        footer: page-footer;
    }
</style>