<html dir="{{$moduleKeys['direction'][$language]}}">

<head>
    <meta charset="utf-8">
    <title>{{$moduleKeys['delivery'][$language]}}</title>


</head>

<body dir="{{$moduleKeys['direction'][$language]}}">
    <div class="frame">

        @section('content')
        <div>
            @include('./components/logo' ,['company' => $company] )
        </div>
        @endsection
        <x-logo :company="$company"></x-logo>


        <h1><u>{{$moduleKeys['listOfDelivery'][$language]}}</u></h1>




        <table class="inventory">

            <tbody>



                <tr>
                    <th width="7%" style="background-color:  #afafaf;"><span>{{$moduleKeys['reference'][$language]}}</span></th>
                    <th width="10%" style="background-color: #afafaf;"><span>{{$moduleKeys['date'][$language]}}</span></th>
                    <th width="11%" style="background-color: #afafaf;"><span> {{$moduleKeys['client'][$language]}}</span></th>
                    <th width="12%" style="background-color: #afafaf;"><span> {{$moduleKeys['customer'][$language]}}</span></th>
                    <th width="7%" style="background-color: #afafaf;"><span> {{$moduleKeys['destPt'][$language]}}</span></th>

                    <th width="9%" style="background-color: #afafaf;"><span>{{$moduleKeys['paymentM'][$language]}} </span></th>
                    <th width="9%" style="background-color: #afafaf;"><span>{{$moduleKeys['typeOfDe'][$language]}} </span></th>
                    <th width="7%" style="background-color: #afafaf;"><span>{{$moduleKeys['curr'][$language]}}</span></th>
                    <th width="9%" style="background-color: #afafaf;"><span>{{$moduleKeys['total'][$language]}}</span></th>
                    @if($currencyBase)
                    <th width="10%" style="background-color: #afafaf;"><span>{{$moduleKeys['total'][$language]}} {{$currencyCode}}</span></th>
                    @endIf
                    <th width="13%" style="background-color: #afafaf;" colspan=2><span>{{$moduleKeys['remark'][$language]}}</span></th>



                </tr>
                @if(isset($delivery[0]->deliveryDt))
                <tr>
                    <!-- <th ><span>Cell Merge</span></th> -->
                    <th><span> {{$moduleKeys['client'][$language]}}</span></th>
                    <th><span>{{$moduleKeys['itemCode'][$language]}}</span></th>
                    <th><span>{{$moduleKeys['des'][$language]}}</span></th>
                    <th><span>{{$moduleKeys['quantity'][$language]}}</span></th>
                    <th><span>{{$moduleKeys['dec3'][$language]}}</span></th>
                    <th><span>{{$moduleKeys['wgt'][$language]}} </span></th>
                    <th><span>{{$moduleKeys['totalWgt'][$language]}}</span></th>
                    <th><span>{{$moduleKeys['uPrice'][$language]}}</span></th>
                    <th><span>{{$moduleKeys['totalPrice'][$language]}}</span></th>
                    @if($currencyBase)
                    <th width="10%"><span>{{$moduleKeys['totalPrice'][$language]}} {{$currencyCode}}</span></th>
                    @endIf
                    <th><span>{{$moduleKeys['pack'][$language]}}</span></th>
                    <th><span>{{$moduleKeys['qty/pack'][$language]}}</span></th>
                    <!-- @if($currency)
                    <th><span>{{$moduleKeys['cost'][$language]}}</span></th>
                    @endif -->

                    <!-- <th ><span>Palet No</span></th> -->


                </tr>
                <tr>
                    <td colspan=12><span></span></td>
                </tr>

                @endIf

                @if(isset($delivery))
                @for($i = 0; $i < count($delivery); $i++ ) <tr>

                    <td><span><b>{{$delivery[$i]->transaction_reference}}</b></span></td>
                    <td><span><b>{{$delivery[$i]->transaction_date}}</b></span></td>
                    <td><span><b>{{$delivery[$i]->client_firstname}}</b></span></td>
                    <td><span><b>{{$delivery[$i]->customer_name}}</b></span></td>
                    <td><span><b>{{$delivery[$i]->transaction_destinationPoint}}</b></span></td>

                    <td><span><b>{{$delivery[$i]->paymentMethodId}}</b></span></td>
                    <td><span><b>{{$delivery[$i]->typeOfDelivery}}</b></span></td>
                    <td><span><b>{{$delivery[$i]->currencyCode}}</b></span></td>


                    <td><span><b>{{number_format($delivery[$i]->sumDTotal,2)}}<b></span></td>
                    @if($currencyBase)
                    <td><span><b>{{number_format($delivery[$i]->sumDTotalBase,2)}}<b></span></td>
                    @endIf


                    @if($currencyBase)
                    <td><span><b></b></span></td>
                    @endIf
                    <td colspan=2><span><b>{{$delivery[$i]->transaction_remark}}</b></span></td>

                    </tr>
                    @if(isset($delivery[$i]->deliveryDt))
                    @for($j =0; $j < count($delivery[$i]->deliveryDt); $j++ )
                        <tr>

                            <!-- <td ><span>{{$delivery[$i]->deliveryDt[$j]->transactiondt_cellMerge}}</span></td> -->
                            <td><span>{{$delivery[$i]->deliveryDt[$j]->client_firstname}}</span></td>
                            <td><span>{{$delivery[$i]->deliveryDt[$j]->item_code}}</span></td>
                            <td><span>{{$delivery[$i]->deliveryDt[$j]->transactiondt_item_description}}</span></td>
                            <td><span>{{$delivery[$i]->deliveryDt[$j]->item_quantity}}</span></td>
                            <td><span>{{$delivery[$i]->deliveryDt[$j]->transactiondt_billOfEntry}}</span></td>
                            <td><span>{{number_format(round($delivery[$i]->deliveryDt[$j]->item_weight,3),2)}}</span></td>
                            <td><span>{{number_format(round($delivery[$i]->deliveryDt[$j]->item_weight*$delivery[$i]->deliveryDt[$j]->item_quantity,3),2)}}</span></td>
                            <td><span>{{number_format(round($delivery[$i]->deliveryDt[$j]->transactiondt_price,3),2)}}</span></td>
                            <td><span>{{number_format(round($delivery[$i]->deliveryDt[$j]->transactiondt_price*$delivery[$i]->deliveryDt[$j]->item_quantity,3),2)}}</span></td>

                            @if($currencyBase)
                            <td><span>{{number_format(round($delivery[$i]->deliveryDt[$j]->transactiondt_priceBase*$delivery[$i]->deliveryDt[$j]->item_quantity,3),2)}}</span></td>
                            @endIf

                            <td><span>{{$delivery[$i]->deliveryDt[$j]->item_pack}}</span></td>

                            <td><span>{{$delivery[$i]->deliveryDt[$j]->item_qtyPerPack}}</span></td>


                        </tr>
                        @endFor
                        @endIf

                        @if(isset($delivery[$i]->deliveryDt))
                        <tr>
                            <td style="border-bottom: 1pt solid black; !important" colspan=12><span></span></td>
                        </tr>
                        <tr>
                            <td colspan=12><span></span></td>
                        </tr>

                        @endIf

                        @endFor
                        @endIf
                        <tr>

                        <td><span></span></td>
                        <td><span></span></td>

                        <td><span></span></td>

                        <td><span></span></td>

                        <td><span></span></td>

                        

                        <td><span></span></td>

                        <td><span></span></td>

                            <td><span>{{number_format(round($totalForInvoice,2),2)}}</span></td>

                            <td><span>{{number_format(round($totalForInvoiceBase),2)}}</span></td>


                        </tr>
            </tbody>
        </table>

    </div>
    <div>
        @include('./components/footer',['company' => $company] )
    </div>

</body>

</html>
<style type="text/css">
    /* reset */

    .frame {
        padding-left: 2%;
        width: 96%;
        max-width: 680px;
        margin: 0;
    }

    * {
        border: 0;
        box-sizing: content-box;
        color: inherit;
        font-family: inherit;
        font-size: inherit;
        font-style: inherit;
        font-weight: inherit;
        line-height: inherit;
        list-style: none;
        margin: 0;
        padding: 0;
        text-decoration: none;
        vertical-align: top;
    }

    /* content editable */

    *[contenteditable] {
        border-radius: 0.25em;
        min-width: 1em;
        outline: 0;
    }

    *[contenteditable] {
        cursor: pointer;
    }

    *[contenteditable]:hover,
    *[contenteditable]:focus,
    td:hover *[contenteditable],
    td:focus *[contenteditable],
    img.hover {
        background: #DEF;
        box-shadow: 0 0 1em 0.5em #DEF;
    }

    span[contenteditable] {
        display: inline-block;
        position: absolute
    }

    /* heading */

    h1 {
        font: bold 100% sans-serif;
        text-align: center;
        text-transform: uppercase;
    }

    hr {
        border: 0;
        clear: both;
        display: block;
        width: 96%;
        background-color: black;
        height: 1px;
        vertical-align: center;
    }

    /* table */

    table {
        font-size: 75%;
        table-layout: fixed;
        width: 100%;
    }

    table {
        border-collapse: separate;
        border-spacing: 2px;
    }

    th,
    td {
        padding: 0.5em;
        position: relative;
        text-align: left;
        position: absolute
    }

    th,
    td {
        border-radius: 0.25em;
        border-style: solid;
        position: absolute
    }

    th {
        background: #E6E6E6;
        border-color: #BBB;
        position: absolute
    }

    td {
        border-color: rgb(170 166 166 / 33%);
        position: absolute
    }

    td.nullclass {
        border-color: #0000
    }

    /* page */

    html {
        font: 16px/1 'Open Sans', sans-serif;
        overflow: auto;
        padding: 0.5in;
    }

    html {
        background: #999;
        cursor: default;
    }

    body {
        box-sizing: border-box;
        height: 11in;
        margin: 0 auto;
        overflow: hidden;
        padding: 0.5in;
        width: 8.5in;
    }

    body {
        background: #FFF;
        border-radius: 1px;
        box-shadow: 0 0 1in -0.25in rgba(0, 0, 0, 0.5);
    }

    /* header */

    header {
        margin: 0 0 0.25em;
    }

    header:after {
        clear: both;
        content: "";
        display: table;
    }

    header h1 {
        padding: 0.5em 0;
    }

    header address {
        float: left;
        font-size: 75%;
        font-style: normal;
        line-height: 1.25;
        margin: 0 1em 1em 0;
    }

    header address p {
        margin: 0 0 0.25em;
    }

    header span,
    header img {
        display: block;
        float: right;
    }

    header span {
        margin: 0 0 1em 1em;
        max-height: 25%;
        max-width: 60%;
        position: relative;
    }

    header img {
        max-height: 100%;
        max-width: 100%;
    }

    header input {
        cursor: pointer;
        -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";
        height: 100%;
        left: 0;
        opacity: 0;
        position: absolute;
        top: 0;
        width: 100%;
    }

    /* article */



    /* invoice title */

    .txt {
        font-size: 75%;
        table-layout: fixed;
        width: 95%;
        position: absolute
    }

    invoiceTitle {
        float: left;
        font-size: 125%;
        font-weight: bold;
        text-align: center;
    }


    /* end invoice title */






    article,
    article address,
    table.meta,
    table.inventory {
        margin: 0 0 3em;
        position: absolute
    }

    article:after {
        clear: both;
        content: "";
        display: table;
    }

    article h1 {
        clip: rect(0 0 0 0);
        position: absolute;
    }

    article address {
        float: left;
        font-size: 125%;
        font-weight: bold;
    }

    /* table meta & balance */

    table.meta,
    table.balance {
        float: right;
        width: 50%;
        text-align: center;
        position: absolute
    }

    table.meta:after,
    table.balance:after {
        clear: both;
        content: "";
        display: table;
        text-align: center;
        position: absolute
    }

    /* table meta */

    table.meta th {
        width: 40%;
        text-align: center;
        position: absolute
    }

    table.meta td {
        width: 60%;
        text-align: center;
        position: absolute
    }

    /* table items */

    table.inventory {
        clear: both;
        width: 100%;
        position: absolute font-size:15px;
    }

    table.inventory th {
        font-weight: bold;
        text-align: center;
        position: absolutefont-size:15px;
    }

    table.inventory td {
        text-align: center;
        position: absolutefont-size:10px;
    }

    table.inventory td.bigFontTd {
        text-align: center;
        position: absolutefont-size:13px;
        font-weight: bold;
    }

    table.inventory td.small {
        text-align: center;
        position: absolutefont-size:8px;
    }

    /* table balance */

    table.balance th,
    table.balance td {
        width: 50%;
        text-align: center;
        position: absolute
    }

    table.balance td {
        text-align: center;
        position: absolute
    }

    /* aside */

    aside h1 {
        border: none;
        border-width: 0 0 1px;
        margin: 0 0 1em;
    }

    aside h1 {
        border-color: #999;
        border-bottom-style: solid;
    }

    /* javascript */

    .add,
    .cut {
        border-width: 1px;
        display: block;
        font-size: .8rem;
        padding: 0.25em 0.5em;
        float: left;
        text-align: center;
        width: 0.6em;
    }

    .fontCustomer {
        font-size: 1.875em;
        /* 30px/16=1.875em */
    }

    .add,
    .cut {
        background: #9AF;
        box-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);
        background-image: -moz-linear-gradient(#00ADEE 5%, #0078A5 100%);
        background-image: -webkit-linear-gradient(#00ADEE 5%, #0078A5 100%);
        border-radius: 0.5em;
        border-color: #0076A3;
        color: #FFF;
        cursor: pointer;
        font-weight: bold;
        text-shadow: 0 -1px 2px rgba(0, 0, 0, 0.333);
    }

    .logo {
        border: none;
        border-width: 0 0 1px;
        margin: 0 0 2em;
    }

    .add {
        margin: -2.5em 0 0;
    }

    .add:hover {
        background: #00ADEE;
    }

    .cut {
        opacity: 0;
        position: absolute;
        top: 0;
        left: -1.5em;
    }

    .cut {
        -webkit-transition: opacity 100ms ease-in;
    }

    tr:hover .cut {
        opacity: 1;
    }

    @media print {
        * {
            -webkit-print-color-adjust: exact;
        }

        html {
            background: none;
            padding: 0;
        }

        body {
            box-shadow: none;
            margin: 0;
        }

        span:empty {
            display: none;
        }

        .add,
        .cut {
            display: none;
        }
    }

    @page {
        margin: 0;
    }

    @page {
        margin-bottom: 50;

        header: page-header;
        footer: page-footer;
    }
</style>